/**
JS Function coundown, designed to take in a deadline date
@params: int yr : deadline year
	 int mo : deadline month (1-12)
	 int da : deadline day (1-31)
	 int deadlineHr: deadline hour (24 hour clock)
	 boolean daylightSavings : set to true if currently in daylight savings(approx Mar-Nov), set to false if not

@return : replaces the html between the following tags:
	  <span id="sec"> seconds remaining </span>
	  <span id="min"> minutes remaining </span>
	  <span id="hrs"> hours remaining </span>
	  <span id="dys"> days remaining </span>

example html code:

  	<span id="dys">00</span>:<span id="hrs">00</span>:<span id="min">00</span>:<span id="sec">00</span>
  	<!--
	<script type="text/javascript" src="http://assets.espn.go.com/js/countdownClock.js"></script>
	<script language="javascript">
	// yr, mo, day, hr (24 hr format)
	countdown(2008, 7, 21, 20, true)
	</script>
 	-->
**/


function countdown(yr, mo, da, deadlineHr){

var montharray = new Array("ene","feb","mar","abr","may","jun","jul","ago","sep","oct","nov","dic");
//deportes should be passing in UTC times, daylight savings not accurate for non-us
var UTCDeadlineHr = deadlineHr;
var UTCMilliseconds = 1000 * 60 * 60 * UTCDeadlineHr;
var today = new Date();
var todayy = today.getUTCFullYear();
if (todayy < 1000)
todayy+=1900;
var todaym = today.getUTCMonth();
var todayd = today.getUTCDate();
var todayh = today.getUTCHours();
var todaymin = today.getUTCMinutes();
var todaysec = today.getUTCSeconds();
// var todaystring = montharray[todaym] + " " + todayd + ", " + todayy + " " + todayh + ":" + todaymin + ":" + todaysec;
//var todaystring = montharray[todaym] + " " + todayd + ", " + todayy;
//var draftstring = montharray[mo-1] + " " + da + ", " + yr ;

//var dd = (Date.parse(draftstring) - Date.parse(todaystring)) + UTCMilliseconds;
//above wasnt working on sdep homepage, date.parse weirdness when time is included
//var tObj = new Date(todayy, todaym, todayd, todayh, todaymin, todaysec);
//var dd = (Date.parse(draftstring) - tObj) + UTCMilliseconds;

td= new Date(Date.UTC(todayy, todaym, todayd, todayh, todaymin, todaysec));
endDate = new Date(Date.UTC(yr, mo-1, da, deadlineHr));
var dd = (endDate - td);


 dday=Math.floor(dd/(60*60*1000*24)*1);
 // TO SHOW DAYS
 dhour=Math.floor((dd%(60*60*1000*24))/(60*60*1000)*1);
 // TO SHOW HOURS
 //dhour=Math.floor((dd%(60*60*1000*24))/(60*60*1000)*1) + dday*24;
 dmin=Math.floor(((dd%(60*60*1000*24))%(60*60*1000))/(60*1000)*1);
 dsec=Math.floor((((dd%(60*60*1000*24))%(60*60*1000))%(60*1000))/1000*1);

 dday = (dday < 0) ? 0 : dday;
 dhour = (dhour < 0) ? 0 : dhour;
 dmin = (dmin < 0) ? 0 : dmin;
 dsec = (dsec < 0) ? 0 : dsec;
 var dayWord = "Days"
 var hourWord = "Hours"
 var minWord = "Minutes"
 var secWord = "Seconds"
 var hourPre = ""
 var minPre = ""
 var secPre = ""
 var dayPre = ""

 if (dday == 1 ) { dayWord = "Day" }
 if (dhour == 1 ) { hourWord = "Hour" }
 if (dmin == 1 ) { minWord = "Minute" }
 if (dsec == 1 ) { secWord = "Second" }

if (dhour < 10) { hourPre = "0" }
if (dmin < 10) { minPre = "0" }
if (dsec < 10) { secPre = "0" }
if (dday < 10) { dayPre = "0" }



document.getElementById('sec').innerHTML = secPre + dsec;
document.getElementById('min').innerHTML = minPre + dmin;
document.getElementById('hrs').innerHTML = hourPre + dhour;
document.getElementById('dys').innerHTML = dayPre + dday;

funcStr = "countdown(" + yr + ',' + mo + ',' + da + ',' + deadlineHr +")"
setTimeout(funcStr,1000)
}